import { T } from "@tldraw/validate";
import { createShapePropsMigrationIds, createShapePropsMigrationSequence } from "../records/TLShape.mjs";
import { DefaultColorStyle } from "../styles/TLColorStyle.mjs";
import { DefaultFontStyle } from "../styles/TLFontStyle.mjs";
import { DefaultSizeStyle } from "../styles/TLSizeStyle.mjs";
import { DefaultTextAlignStyle } from "../styles/TLTextAlignStyle.mjs";
const textShapeProps = {
  color: DefaultColorStyle,
  size: DefaultSizeStyle,
  font: DefaultFontStyle,
  textAlign: DefaultTextAlignStyle,
  w: T.nonZeroNumber,
  text: T.string,
  scale: T.nonZeroNumber,
  autoSize: T.boolean
};
const Versions = createShapePropsMigrationIds("text", {
  RemoveJustify: 1,
  AddTextAlign: 2
});
const textShapeMigrations = createShapePropsMigrationSequence({
  sequence: [
    {
      id: Versions.RemoveJustify,
      up: (props) => {
        if (props.align === "justify") {
          props.align = "start";
        }
      },
      down: "retired"
    },
    {
      id: Versions.AddTextAlign,
      up: (props) => {
        props.textAlign = props.align;
        delete props.align;
      },
      down: (props) => {
        props.align = props.textAlign;
        delete props.textAlign;
      }
    }
  ]
});
export {
  textShapeMigrations,
  textShapeProps,
  Versions as textShapeVersions
};
//# sourceMappingURL=TLTextShape.mjs.map
